package gov.va.med.mhv.admin.web.formbean;

import java.io.Serializable;
import java.util.Date;

import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;


@ManagedBean(name = "attendedSearchInfo")
@SessionScoped
public class AttendedSearchFormBean implements Serializable {

	private static final long serialVersionUID = -8171483642271114893L;

	private String firstName;
	private String middleName;
	private String lastName;
	private String gender;
	private String ssn;
	private String ssn3;
	private String ssn2;
	private String ssn4;
	private Date birthDate;
	private String email;
	private String relationshipToVA;
	private String mhvId;
	private Long referenceNumber;
	private String homePhone;
	private String birthCity;
	private String birthState;
	private String mothersMaidenName;
	private String addressStreet;
	private String addressCity;
	private String addressState;
	private String addressZip;
	private String nameOfHCIdMRep;
	private Date latestDate;

	private Boolean displaySearchMviButton;
	
	public void reset() {
		firstName = null;
		middleName = null;
		lastName = null;
		gender = null;
		ssn = null;
		ssn3 = null;
		ssn2 = null;
		ssn4 = null;
		birthDate = null;
		email = null;
		relationshipToVA = null;
		mhvId = null;
		referenceNumber = null;
		homePhone = null;
		birthCity = null;
		birthState = null;
		mothersMaidenName = null;
		addressStreet = null;
		addressCity = null;
		addressState = null;
		addressZip = null;
		nameOfHCIdMRep = null;
		latestDate = null;
	}

	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getMiddleName() {
		return this.middleName;
	}

	public void setMiddleName(String middleName) {
		this.middleName = middleName;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getGender() {
		return this.gender;
	}

	public void setGender(String gender) {
		this.gender = gender;
	}

	/**
	 * @return Returns <code>M</code> or <code>F</code> or <code>null</code>.
	 */
	public String getGenderAbbreviated() {
		if ("m".equalsIgnoreCase(this.gender) || "male".equalsIgnoreCase(this.gender)) {
			return "M";
		}
		if ("f".equalsIgnoreCase(this.gender) || "female".equalsIgnoreCase(this.gender)) {
			return "F";
		}
		return null;
	}

	/**
	 * @return The SSN in the form of '333-22-4444', or <code>null</code>
	 */
	public String getSsn() {
		if (this.ssn == null) {
			if (this.ssn3 != null && this.ssn2 != null && this.ssn4 != null) {
				this.ssn = this.ssn3 + this.ssn2 + this.ssn4;
			}
		}
		return this.ssn;
	}

	/**
	 * @return The SSN in the form of '333224444', or <code>null</code>
	 */
	public String getSsnUnformatted() {
		if (this.ssn3 != null && this.ssn2 != null && this.ssn4 != null) {
			return this.ssn3 + this.ssn2 + this.ssn4;
		}
		return null;
	}

	/**
	 * Accepts a SSN value as a <code>String</code> in the form of 333-22-4444
	 * or 333224444. Sets a value of <code>null</code> if the given SSN is not
	 * in the right format.
	 * 
	 * @param ssn
	 *            The SSN.
	 */
	public void setSsn(String ssn) {
		try {
			if (ssn.indexOf("-") == -1 && ssn.length() == 9) {
				this.ssn3 = ssn.substring(0, 3);
				this.ssn2 = ssn.substring(3, 5);
				this.ssn4 = ssn.substring(5);
				this.ssn = this.ssn3 + "-" + this.ssn2 + "-" + this.ssn4;
			} else if (ssn.indexOf("-") != -1 && ssn.length() == 11) {
				String[] segments = ssn.split("-");
				this.ssn = ssn;
				this.ssn3 = segments[0];
				this.ssn2 = segments[1];
				this.ssn4 = segments[2];
			} else {
				this.ssn = null;
				this.ssn3 = null;
				this.ssn2 = null;
				this.ssn4 = null;
			}
		} catch (Exception e) {
			// do nothing
		}
	}

	public String getSsn3() {
		return this.ssn3;
	}

	public void setSsn3(String ssn3) {
		this.ssn3 = ssn3;
	}

	public String getSsn2() {
		return this.ssn2;
	}

	public void setSsn2(String ssn2) {
		this.ssn2 = ssn2;
	}

	public String getSsn4() {
		return this.ssn4;
	}

	public void setSsn4(String ssn4) {
		this.ssn4 = ssn4;
	}

	public Date getBirthDate() {
		return this.birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public String getEmail() {
		return this.email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public String getRelationshipToVA() {
		return this.relationshipToVA;
	}

	public void setRelationshipToVA(String relationshipToVA) {
		this.relationshipToVA = relationshipToVA;
	}

	public String getMhvId() {
		return this.mhvId;
	}

	public void setMhvId(String mhvId) {
		this.mhvId = mhvId;
	}

	public Long getReferenceNumber() {
		return this.referenceNumber;
	}

	public void setReferenceNumber(Long referenceNumber) {
		this.referenceNumber = referenceNumber;
	}

	public String getHomePhone() {
		return this.homePhone;
	}

	/**
	 * If needed, converts these types of phone number formats (801) 666-4321,
	 * 801-666-4321, 801.666.4321, 801 666 4321, etc. to 8016664321.
	 * 
	 * @return the home phone number in this format 8016664321, or
	 *         <code>null</code>.
	 */
	public String getHomePhoneUnformatted() {
		if (this.homePhone != null && !this.homePhone.isEmpty()) {
			return this.homePhone.replaceAll("\\s|\\(|\\)|-|\\.", ""); 
		}
		return null;
	}

	public void setHomePhone(String homePhone) {
		this.homePhone = homePhone;
	}

	public String getBirthCity() {
		return this.birthCity;
	}

	public void setBirthCity(String birthCity) {
		this.birthCity = birthCity;
	}

	public String getBirthState() {
		return this.birthState;
	}

	public void setBirthState(String birthState) {
		this.birthState = birthState;
	}

	public String getMothersMaidenName() {
		return this.mothersMaidenName;
	}

	public void setMothersMaidenName(String mothersMaidenName) {
		this.mothersMaidenName = mothersMaidenName;
	}

	public String getAddressStreet() {
		return this.addressStreet;
	}

	public void setAddressStreet(String addressStreet) {
		this.addressStreet = addressStreet;
	}

	public String getAddressCity() {
		return this.addressCity;
	}

	public void setAddressCity(String addressCity) {
		this.addressCity = addressCity;
	}

	public String getAddressState() {
		return this.addressState;
	}

	public void setAddressState(String addressState) {
		this.addressState = addressState;
	}

	public String getAddressZip() {
		if (this.addressZip != null && !this.addressZip.isEmpty()) {
			return this.addressZip.trim();
		} else {
			return null;
		}
	}

	public void setAddressZip(String addressZip) {
		this.addressZip = addressZip;
	}

	public String getNameOfHCIdMRep() {
		return this.nameOfHCIdMRep;
	}

	public void setNameOfHCIdMRep(String nameOfHCIdMRep) {
		this.nameOfHCIdMRep = nameOfHCIdMRep;
	}

	public Date getLatestDate() {
		latestDate = new Date();
		return latestDate;
	}

	public void setLatestDate(Date latestDate) {
		this.latestDate = latestDate;
	}

	public Boolean getDisplaySearchMviButton() {
		return this.displaySearchMviButton;
	}

	public void setDisplaySearchMviButton(Boolean displaySearchMviButton) {
		this.displaySearchMviButton = displaySearchMviButton;
	}

}
